# ideas/admin.py

from django.contrib import admin
from .models import RefinementQuestion, User, Category, Tag, Campaign, Idea, Comment, Attachment, Notification,EvaluationCriterion,EvaluationResult
from django.contrib.auth.admin import UserAdmin
# تنظیمات نمایش کاربر در ادمین
class CustomUserAdmin(UserAdmin):
    fieldsets = UserAdmin.fieldsets + (
        ('Custom Fields', {'fields': ('role',)}), # اضافه کردن فیلد role به فرم ویرایش
    )
    list_display = ('username', 'email', 'role', 'is_staff')
# ما به جنگو می‌گوییم که این مدل‌ها را در پنل ادمین نمایش بده
admin.site.register(Category)
admin.site.register(Tag)
admin.site.register(Campaign)
admin.site.register(Idea)
admin.site.register(Comment)
admin.site.register(Attachment)
admin.site.register(Notification)
admin.site.register(User, CustomUserAdmin)
@admin.register(RefinementQuestion)
class RefinementQuestionAdmin(admin.ModelAdmin):
    list_display = ('order', 'title', 'is_active')
    list_editable = ('is_active',)
    ordering = ('order',)
    
@admin.register(EvaluationCriterion)
class EvaluationCriterionAdmin(admin.ModelAdmin):
    list_display = ("key", "title", "weight", "is_active")
    list_editable = ("weight", "is_active")
    search_fields = ("key", "title")

