from django.core.management.base import BaseCommand
from ideas.models import EvaluationCriterion

class Command(BaseCommand):
    help = "Seed evaluation criteria with standard weights"

    def handle(self, *args, **options):
        criteria = [
            ("Strategic Alignment", "strategic_alignment", 20),
            ("Economic Feasibility", "economic_feasibility", 20),
            ("Technical Feasibility", "technical_feasibility", 15),
            ("Risk Level", "risk_level", 15),
            ("Time to Value", "time_to_value", 15),
            ("Novelty", "novelty", 15),
        ]

        for title, key, weight in criteria:
            obj, created = EvaluationCriterion.objects.update_or_create(
                key=key,
                defaults={
                    "title": title,
                    "weight": weight,
                    "is_active": True,
                },
            )

            action = "CREATED" if created else "UPDATED"
            self.stdout.write(
                self.style.SUCCESS(f"{action}: {obj.key} ({obj.weight})")
            )

        self.stdout.write(
            self.style.SUCCESS("✅ Evaluation criteria seeded successfully")
        )