BASE_THRESHOLDS = {
    "next": 75,
    "revise": 60,
    "backlog": 50,
}

LEVEL_INCREMENT = 5


def calculate_decision(final_score: float, h_level: str) -> str:
    """
    Pure decision function
    No side-effects
    """

    try:
        level_index = int(h_level[1:]) - 1   # H1 -> 0 / H2 -> 1 / H3 -> 2
    except (ValueError, IndexError, TypeError):
        level_index = 0  # fallback to H1

    thresholds = {
        key: value + (level_index * LEVEL_INCREMENT)
        for key, value in BASE_THRESHOLDS.items()
    }

    if final_score >= thresholds["next"]:
        return "next"
    if final_score >= thresholds["revise"]:
        return "revise"
    if final_score >= thresholds["backlog"]:
        return "backlog"
    return "archive"
