# ideas/urls.py
from django.urls import path, include
from rest_framework_nested import routers
from .views import  IdeaViewSet, ActivityLogViewSet
from django.conf import settings
from django.conf.urls.static import static
from .views import (
    UserViewSet, CategoryViewSet, TagViewSet,
    CampaignViewSet, IdeaViewSet,
    CommentViewSet, AttachmentViewSet,
    AnalyticsSummaryAPIView, NotificationViewSet,RefinementReviewView,RefinementQuestionListView,EvaluationCriteriaListView
)

router = routers.DefaultRouter()
router.register(r'users', UserViewSet, basename='user')
router.register(r'categories', CategoryViewSet, basename='category')
router.register(r'tags', TagViewSet, basename='tag')
router.register(r'campaigns', CampaignViewSet, basename='campaign')
router.register(r'ideas', IdeaViewSet, basename='idea')
router.register(r'notifications', NotificationViewSet, basename='notification')
router.register(
    r'ideas/(?P<idea_id>\d+)/activity',
    ActivityLogViewSet,
    basename='activity-log'
)

# nested: /ideas/{idea_pk}/comments/, /ideas/{idea_pk}/attachments/
ideas_router = routers.NestedDefaultRouter(router, r'ideas', lookup='idea')
ideas_router.register(r'comments', CommentViewSet, basename='idea-comments')
ideas_router.register(r'attachments', AttachmentViewSet, basename='idea-attachments')

urlpatterns = [
    path('', include(router.urls)),
    path('', include(ideas_router.urls)),
    path('analytics/summary/', AnalyticsSummaryAPIView.as_view(), name='analytics-summary'),
    path(
        'refinement/questions/',
        RefinementQuestionListView.as_view(),
        name='refinement-questions'
    ),
    path(
        "ideas/<int:idea_id>/refinement-review/",
        RefinementReviewView.as_view(),
        name="refinement-review",
    ),
    path(
        "evaluation-criteria/", EvaluationCriteriaListView.as_view(),name='evaluation-criteria-list'),
    
]
# ... کدهای قبلی و urlpatterns ...
if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)


