# ideas/urls.py

from django.urls import path, include
from rest_framework_nested import routers
from .views import (
    UserViewSet,
    CampaignViewSet,
    CategoryViewSet,
    IdeaViewSet,
    CommentViewSet,
    AttachmentViewSet,
    TagViewSet,
    AnalyticsSummaryAPIView,
    NotificationViewSet
)

# روتر اصلی برای آدرس‌های سطح بالا
router = routers.DefaultRouter()
router.register(r'users', UserViewSet)
router.register(r'campaigns', CampaignViewSet)
router.register(r'categories', CategoryViewSet)
router.register(r'tags', TagViewSet)
router.register(r'ideas', IdeaViewSet)
router.register(r'notifications', NotificationViewSet, basename='notifications') # <<< این خط جدید است

# روتر تو در تو برای کامنت‌ها و پیوست‌های زیرمجموعه یک ایده
ideas_router = routers.NestedDefaultRouter(router, r'ideas', lookup='idea')
ideas_router.register(r'comments', CommentViewSet, basename='idea-comments')
ideas_router.register(r'attachments', AttachmentViewSet, basename='idea-attachments')

# لیست نهایی آدرس‌ها
urlpatterns = [
    # همه آدرس‌های اصلی و تو در تو را به ترتیب اضافه می‌کنیم
    path('', include(router.urls)),
    path('', include(ideas_router.urls)),
    
    # آدرس برای ویوی آماری شما
    path('analytics/summary/', AnalyticsSummaryAPIView.as_view(), name='analytics-summary'),
]