# settings.py

from pathlib import Path
import os
from dotenv import load_dotenv # <<< این خط رو اضافه کن
BASE_DIR = Path(__file__).resolve().parent.parent
load_dotenv(os.path.join(BASE_DIR, '.env'))
SECRET_KEY = os.getenv('SECRET_KEY')
DEBUG = os.getenv('DEBUG', 'False') == 'True'
ALLOWED_HOSTS = []

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'rest_framework',
    'djoser',
    'corsheaders',
    'django_filters',
    'ideas',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'corsheaders.middleware.CorsMiddleware',  # <<< باید اینجا، نزدیک به بالا باشه
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

# !!! نکته مهم: به جای 'your_project_name' اسم پوشه اصلی پروژه‌تون رو بذارید
ROOT_URLCONF = 'project_name.urls' # من فرض کردم اسم پوشه پروژه شما backend هست
WSGI_APPLICATION = 'project_name.wsgi.application' # این رو هم بر اساس فرض بالا تغییر دادم

# ==============================================================================
# ## این بخش جدید برای حل خطای ADMIN اضافه شده است ##
# ==============================================================================
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True, # این خط به جنگو میگه تمپلیت‌ها رو از داخل پوشه اپ‌ها بخونه
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

DATABASES = {
'default': {
        'ENGINE': 'django.db.backends.postgresql',
        'NAME': os.getenv('DB_NAME'),         # <<< از متغیر محیطی
        'USER': os.getenv('DB_USER'),         # <<< از متغیر محیطی
        'PASSWORD': os.getenv('DB_PASSWORD'), # <<< از متغیر محیطی
        'HOST': os.getenv('DB_HOST'),         # <<< از متغیر محیطی
        'PORT': os.getenv('DB_PORT'),         # <<< از متغیر محیطی
    }
}

LANGUAGE_CODE = 'en-us'
TIME_ZONE = 'UTC'
USE_I18N = True
USE_TZ = True

STATIC_URL = 'static/'

# ==============================================================================
# ## این بخش جدید برای حل هشدارهای Primary Key اضافه شده است ##
# ==============================================================================
DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'


AUTH_USER_MODEL = 'ideas.User'

REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': ('rest_framework_simplejwt.authentication.JWTAuthentication',),
    'DEFAULT_PERMISSION_CLASSES': ('rest_framework.permissions.IsAuthenticated',),
    'DEFAULT_PAGINATION_CLASS': 'rest_framework.pagination.PageNumberPagination',
    'PAGE_SIZE': 10,
    'DEFAULT_FILTER_BACKENDS': ('django_filters.rest_framework.DjangoFilterBackend',),
}

DJOSER = {
    'USER_ID_FIELD': 'id',
    'USER_CREATE_PASSWORD_RETYPE': True,
    'USERNAME_RESET_CONFIRM_RETYPE': True,
    'PASSWORD_RESET_CONFIRM_RETYPE': True,
    'SERIALIZERS': {
        'user_create': 'ideas.serializers.UserCreateSerializer',
        'current_user': 'ideas.serializers.UserSerializer',
        'user': 'ideas.serializers.UserSerializer',
    }
}

CORS_ALLOWED_ORIGINS = [
    "http://localhost:3000",
    "http://127.0.0.1:3000",
]


# --- تنظیمات فایل‌های استاتیک ---
STATIC_URL = '/static/'
# مسیری که جنگو فایل‌های استاتیک همه‌ی اپ‌ها رو اونجا جمع می‌کنه (داخل کانتینر)
STATIC_ROOT = BASE_DIR / 'staticfiles'
# به جنگو می‌گه چطور فایل‌های استاتیک رو در production مدیریت کنه
STORAGES = {
    "default": {
            "BACKEND": "django.core.files.storage.FileSystemStorage",
        },
        # این بخش برای فایل‌های استاتیک (با WhiteNoise) است
        "staticfiles": {
            "BACKEND": "whitenoise.storage.CompressedManifestStaticFilesStorage",
        },
}

# --- تنظیمات فایل‌های مدیا ---
MEDIA_URL = '/media/'
# مسیری که فایل‌های آپلودی کاربران اونجا ذخیره می‌شه (داخل کانتینر)
MEDIA_ROOT = BASE_DIR / 'mediafiles'


if DEBUG:
    SECURE_CROSS_ORIGIN_OPENER_POLICY = None
    SECURE_CROSS_ORIGIN_EMBEDDER_POLICY = None
